% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.fund.R
\name{trace.fund}
\alias{trace.fund}
\title{trace.fund}
\usage{
trace.fund(
  wave,
  hop = 5,
  wl = 200,
  freq_lim = c(1.1, 4),
  spar = 0.4,
  noise_factor = 3.5,
  thr = 0.3
)
}
\arguments{
\item{wave}{wave object, e.g., from `load.wave` or `readWave`.}

\item{hop}{integer, how many samples to skip for each trace point.}

\item{wl}{integer, window length for the spectrum}

\item{freq_lim}{numeric vector of length 2, frequency in kHz between which to find the fundamental}

\item{spar}{numeric between 0-1, for the `smooth.spline` function}

\item{noise_factor}{numeric, how much louder the fundamental has to be than the noise to be accepted}

\item{thr}{numeric between 0-1, the fraction of the maximum of the spectrum used to detect the fundamental}
}
\value{
Data frame with time = time in seconds, fund = fundamental frequency in Hz and missing = logical
indicating if the fundamental was detected (`TRUE`) or interpolated (`FALSE`).
}
\description{
Traces the fundamental frequency from a wave object. Also applies smoothening to trace.
}
