% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{calculateGoF}
\alias{calculateGoF}
\title{Internal: GoF}
\usage{
calculateGoF(
 .object              = NULL,
 .only_common_factors = TRUE
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.only_common_factors}{Logical. Should only concepts modeled as common
factors be included when calculating one of the following quality critera:
AVE, the Fornell-Larcker criterion, HTMT, and all reliability estimates.
Defaults to \code{TRUE}.}
}
\value{
A single numeric value.
}
\description{
Calculate the Goodness of Fit (GoF) proposed by \insertCite{Tenenhaus2004;textual}{cSEM}.
Note that, contrary to what the name suggests, the GoF is \strong{not} a
measure of model fit in the sense of SEM. See e.g. \insertCite{Henseler2012a;textual}{cSEM}
for a discussion.
}
\details{
The function is only applicable to objects inheriting class \code{cSEMResults_default}.
For objects of class \code{cSEMResults_multi} and \code{cSEMResults_2ndorder} use \code{\link[=assess]{assess()}}.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=assess]{assess()}}, \link{cSEMResults}
}
\keyword{internal}
