% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{rawTable}
\alias{rawTable}
\title{Create a table with norm scores assigned to raw scores for a specific age based on the regression model}
\usage{
rawTable(
  A,
  model,
  minRaw = NULL,
  maxRaw = NULL,
  minNorm = NULL,
  maxNorm = NULL,
  step = 1,
  monotonuous = TRUE,
  CI = 0.9,
  reliability = NULL,
  pretty = TRUE
)
}
\arguments{
\item{A}{the age, either single value or vector with age values}

\item{model}{The regression model or a cnorm object}

\item{minRaw}{The lower bound of the raw score range}

\item{maxRaw}{The upper bound of the raw score range}

\item{minNorm}{Clipping parameter for the lower bound of norm scores (default 25)}

\item{maxNorm}{Clipping parameter for the upper bound of norm scores (default 25)}

\item{step}{Stepping parameter for the raw scores (default 1)}

\item{monotonuous}{corrects for decreasing norm scores in case of model inconsistencies (default)}

\item{CI}{confidence coefficient, ranging from 0 to 1, default .9}

\item{reliability}{coefficient, ranging between  0 to 1}

\item{pretty}{Format table by collapsing intervals and rounding to meaningful precision}
}
\value{
either data.frame with raw scores and the predicted norm scores in case of simple A value or a list
of norm tables if vector of A values was provided
}
\description{
This function is comparable to 'normTable', despite it reverses the assignment:
A table with raw scores and the according norm scores for a specific age based on the regression
model is generated. This way, the inverse function of the regression model is solved numerically with
brute force. Please specify the range of raw values, you want to cover. With higher precision
and smaller stepping, this function becomes computational intensive.
In case a confidence coefficient (CI, default .9) and the reliability is specified,
confidence intervals are computed for the true score estimates, including a correction for
regression to the mean (Eid & Schmidt, 2012, p. 272).
}
\examples{
# Generate cnorm object from example data
cnorm.elfe <- cnorm(raw = elfe$raw, group = elfe$group)
# generate a norm table for the raw value range from 0 to 28 for the time point month 7 of grade 3
table <- rawTable(3 + 7 / 12, cnorm.elfe, minRaw = 0, maxRaw = 28)

# generate several raw tables
table <- rawTable(c(2.5, 3.5, 4.5), cnorm.elfe, minRaw = 0, maxRaw = 28)

# additionally compute confidence intervals
table <- rawTable(c(2.5, 3.5, 4.5), cnorm.elfe, minRaw = 0, maxRaw = 28, CI = .9, reliability = .94)

# conventional norming, set age to arbitrary value
model <- cnorm(raw=elfe$raw)
rawTable(0, model)

}
\references{
Eid, M. & Schmidt, K. (2012). Testtheorie und Testkonstruktion. Hogrefe.
}
\seealso{
normTable

Other predict: 
\code{\link{derivationTable}()},
\code{\link{getNormCurve}()},
\code{\link{normTable}()},
\code{\link{predict.cnormBetaBinomial}()},
\code{\link{predict.cnormBetaBinomial2}()},
\code{\link{predict.cnormShaSh}()},
\code{\link{predictNorm}()},
\code{\link{predictRaw}()}
}
\concept{predict}
