% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp.R
\name{bp}
\alias{bp}
\alias{lik.bp}
\alias{rbp}
\title{The bivariate poisson distribution}
\usage{
lik.bp(xvec, yvec, m0, m1, m2, param = NULL)

rbp(n, m0, m1, m2, param = NULL)

bp(xvec, yvec, tol = 1e-06)
}
\arguments{
\item{xvec, yvec}{a pair of bp random vectors. nonnegative integer vectors. 
If not integers, they will be rounded to the nearest integers.}

\item{m0, m1, m2}{mean parameters of the Poisson variables. They must be positive.}

\item{param}{a vector of parameters (\code{(m0, m1, m2)}). 
Either \code{param} or individual parameters (\code{m0, m1, m2}) 
need to be provided.}

\item{n}{number of observations.}

\item{tol}{tolerance for judging convergence. \code{tol = 1e-8} by default.}
}
\value{
\itemize{
   \item \code{rbp} gives a pair of random vectors following BP distribution.
   \item \code{bp} gives the maximum likelihood estimates of a BP pair.
   \item \code{lik.bp} gives the log-likelihood of a set of parameters for a BP pair.

 }
}
\description{
random generation (\code{rbp}), maximum likelihood estimation (\code{bp}), 
   and log-likelihood. (\code{lik.bp})  for the bivariate Poisson 
   distribution with parameters equal to \code{(m0, m1, m2)}.
}
\examples{
# generating a pair of random vectors
set.seed(1)
data1 <- rbp(n = 20, m0 = 1, m1 = 1, m2 = 1)

lik.bp(xvec = data1[, 1], yvec = data1[ ,2], 
          m0 = 1, m1 = 1, m2 = 1) 

bp(xvec = data1[,1], yvec = data1[,2])

}
\references{
Cho, H., Liu, C., Preisser, J., and Wu, D. (In preparation), "A bivariate 
 zero-inflated negative binomial model for identifying underlying dependence"

 Kocherlakota, S. & Kocherlakota, K. (1992). Bivariate Discrete Distributions. New York: Marcel Dekker.
}
\author{
Hunyong Cho, Chuwen Liu, Jinyoung Park, and Di Wu
}
