% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-vharlse.R, R/print-vharlse.R
\name{summary.vharlse}
\alias{summary.vharlse}
\alias{print.summary.vharlse}
\alias{knit_print.summary.vharlse}
\title{Summarizing Vector HAR Model}
\usage{
\method{summary}{vharlse}(object, ...)

\method{print}{summary.vharlse}(x, digits = max(3L, getOption("digits") - 3L), signif_code = TRUE, ...)

\method{knit_print}{summary.vharlse}(x, ...)
}
\arguments{
\item{object}{A \code{vharlse} object}

\item{...}{not used}

\item{x}{\code{summary.vharlse} object}

\item{digits}{digit option to print}

\item{signif_code}{Check significant rows (Default: \code{TRUE})}
}
\value{
\code{summary.vharlse} \link{class} additionally computes the following
\item{\code{names}}{Variable names}
\item{\code{totobs}}{Total number of the observation}
\item{\code{obs}}{Sample size used when training = \code{totobs} - \code{p}}
\item{\code{p}}{3}
\item{\code{week}}{Order for weekly term}
\item{\code{month}}{Order for monthly term}
\item{\code{coefficients}}{Coefficient Matrix}
\item{\code{call}}{Matched call}
\item{\code{process}}{Process: VAR}
\item{\code{covmat}}{Covariance matrix of the residuals}
\item{\code{corrmat}}{Correlation matrix of the residuals}
\item{\code{roots}}{Roots of characteristic polynomials}
\item{\code{is_stable}}{Whether the process is stable or not based on \code{roots}}
\item{\code{log_lik}}{log-likelihood}
\item{\code{ic}}{Information criteria vector}
\itemize{
\item{\code{AIC}} - AIC
\item{\code{BIC}} - BIC
\item{\code{HQ}} - HQ
\item{\code{FPE}} - FPE
}
}
\description{
\code{summary} method for \code{vharlse} class.
}
\references{
Lütkepohl, H. (2007). \emph{New Introduction to Multiple Time Series Analysis}. Springer Publishing.

Corsi, F. (2008). \emph{A Simple Approximate Long-Memory Model of Realized Volatility}. Journal of Financial Econometrics, 7(2), 174-196.

Baek, C. and Park, M. (2021). \emph{Sparse vector heterogeneous autoregressive modeling for realized volatility}. J. Korean Stat. Soc. 50, 495-510.
}
