% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.R, R/print-bvharspec.R, R/member.R
\name{set_ng}
\alias{set_ng}
\alias{print.ngspec}
\alias{is.ngspec}
\title{Normal-Gamma Hyperparameter for Coefficients and Contemporaneous Coefficients}
\usage{
set_ng(
  shape_sd = 0.01,
  group_shape = 0.01,
  group_scale = 0.01,
  global_shape = 0.01,
  global_scale = 0.01,
  contem_global_shape = 0.01,
  contem_global_scale = 0.01
)

\method{print}{ngspec}(x, digits = max(3L, getOption("digits") - 3L), ...)

is.ngspec(x)
}
\arguments{
\item{shape_sd}{Standard deviation used in MH of Gamma shape}

\item{group_shape}{Inverse gamma prior shape for coefficient group shrinkage}

\item{group_scale}{Inverse gamma prior scale for coefficient group shrinkage}

\item{global_shape}{Inverse gamma prior shape for coefficient global shrinkage}

\item{global_scale}{Inverse gamma prior scale for coefficient global shrinkage}

\item{contem_global_shape}{Inverse gamma prior shape for contemporaneous coefficient global shrinkage}

\item{contem_global_scale}{Inverse gamma prior scale for contemporaneous coefficient global shrinkage}

\item{x}{\code{ngspec}}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{ngspec} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Set NG hyperparameters for VAR or VHAR coefficient and contemporaneous coefficient.
}
\references{
Chan, J. C. C. (2021). \emph{Minnesota-type adaptive hierarchical priors for large Bayesian VARs}. International Journal of Forecasting, 37(3), 1212-1226.

Huber, F., & Feldkircher, M. (2019). \emph{Adaptive Shrinkage in Bayesian Vector Autoregressive Models}. Journal of Business & Economic Statistics, 37(1), 27-39.

Korobilis, D., & Shimizu, K. (2022). \emph{Bayesian Approaches to Shrinkage and Sparse Estimation}. Foundations and Trends® in Econometrics, 11(4), 230-354.
}
