% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvar-hierarchical.R
\name{bvar_niwhm}
\alias{bvar_niwhm}
\alias{print.bvarhm}
\alias{knit_print.bvarhm}
\title{Fitting Hierarchical Bayesian VAR(p)}
\usage{
bvar_niwhm(
  y,
  p,
  num_iter = 1000,
  num_burn = floor(num_iter/2),
  thinning = 1,
  bayes_spec = set_bvar(sigma = set_psi(), lambda = set_lambda()),
  scale_variance = 0.05,
  include_mean = TRUE,
  parallel = list(),
  verbose = FALSE
)

\method{print}{bvarhm}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{bvarhm}(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{p}{VAR lag}

\item{num_iter}{MCMC iteration number}

\item{num_burn}{Number of burn-in (warm-up). Half of the iteration is the default choice.}

\item{thinning}{Thinning every thinning-th iteration}

\item{bayes_spec}{A BVAR model specification by \code{\link[=set_ssvs]{set_ssvs()}}.}

\item{scale_variance}{Proposal distribution scaling constant to adjust an acceptance rate}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{parallel}{List the same argument of \code{\link[optimParallel:optimParallel]{optimParallel::optimParallel()}}. By default, this is empty, and the function does not execute parallel computation.}

\item{verbose}{Print the progress bar in the console. By default, \code{FALSE}.}

\item{x}{\code{bvarhm} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{bvar_niwhm} returns an object named \code{bvarhm} \link{class}.
It is a list with the following components:

\describe{
\item{coefficients}{Coefficient Matrix}
\item{p}{Lag of VAR}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{p}}
\item{totobs}{Total number of the observation}
\item{call}{Matched call}
\item{type}{include constant term (\code{"const"}) or not (\code{"none"})}
\item{y0}{\eqn{Y_0}}
\item{design}{\eqn{X_0}}
\item{y}{Raw input}
}
}
\description{
This function fits hierarchical BVAR(p) with general Minnesota prior.
}
\details{
SSVS prior gives prior to parameters \eqn{\alpha = vec(A)} (VAR coefficient) and \eqn{\Sigma_e^{-1} = \Psi \Psi^T} (residual covariance).

\deqn{\alpha_j \mid \gamma_j \sim (1 - \gamma_j) N(0, \kappa_{0j}^2) + \gamma_j N(0, \kappa_{1j}^2)}
\deqn{\gamma_j \sim Bernoulli(q_j)}

and for upper triangular matrix \eqn{\Psi},

\deqn{\psi_{jj}^2 \sim Gamma(shape = a_j, rate = b_j)}
\deqn{\psi_{ij} \mid w_{ij} \sim (1 - w_{ij}) N(0, \kappa_{0,ij}^2) + w_{ij} N(0, \kappa_{1,ij}^2)}
\deqn{w_{ij} \sim Bernoulli(q_{ij})}

Gibbs sampler is used for the estimation.
See \link{ssvs_bvar_algo} how it works.
}
\references{
Bańbura, M., Giannone, D., & Reichlin, L. (2010). \emph{Large Bayesian vector auto regressions}. Journal of Applied Econometrics, 25(1).

Giannone, D., Lenza, M., & Primiceri, G. E. (2015). \emph{Prior Selection for Vector Autoregressions}. Review of Economics and Statistics, 97(2).

Litterman, R. B. (1986). \emph{Forecasting with Bayesian Vector Autoregressions: Five Years of Experience}. Journal of Business & Economic Statistics, 4(1), 25.
}
