% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gsheets.R
\name{read_gsheets}
\alias{read_gsheets}
\title{Import Data from Multiple Sheets in Google Sheets}
\usage{
read_gsheets(ss, col_types = NULL, .id = NULL)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet:
\itemize{
\item its file id as a string or \code{\link[googledrive:drive_id]{drive_id}}
\item a URL from which we can recover the id
\item a one-row \code{\link[googledrive:dribble]{dribble}}, which is how googledrive
represents Drive files
\item an instance of \code{googlesheets4_spreadsheet}, which is what \code{\link[googlesheets4:gs4_get]{gs4_get()}}
returns
}

Processed through \code{\link[googlesheets4:as_sheets_id]{as_sheets_id()}}.}

\item{col_types}{Column types. Either \code{NULL} to guess all from the
spreadsheet or a string of readr-style shortcodes, with one character or
code per column. If exactly one \code{col_type} is specified, it is recycled.
See Column Specification for more.}

\item{.id}{The name of an optional identifier column. Provide a string to
create an output column that identifies each input. The column will use
names if available, otherwise it will use positions.}
}
\value{
A \link[tibble:tibble-package]{tibble}. If there is any column type mismatch during data frames row binding, an error will occur. This is because R cannot combine columns of different types. For example, you cannot combine a column of integers with a column of characters.
}
\description{
The \code{read_gsheets()} function imports data from multiple sheets in a Google Sheets spreadsheet and appends the resulting dataframes from each sheet together to create a single dataframe. This function is a powerful tool for data analysis, as it allows you to easily combine data from multiple sheets into a single dataset.
}
\examples{
\dontshow{if (googlesheets4::gs4_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

sheet_id <- "1izO0mHu3L9AMySQUXGDn9GPs1n-VwGFSEoAKGhqVQh0"

read_gsheets(ss = sheet_id, .id = "sheet.name")

# Column types mismatch error --------------------------------------
# If the `read_gsheets()` function complains about a data type mismatch,
# then set the `col_types` argument to `"c"`.
# This will make all the column types in the resulting dataframe be characters.

# For example,
\dontshow{\}) # examplesIf}
\dontshow{if (googlesheets4::gs4_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sheet_id <- "1rrjKAV05POre9lDVtHtZePTa8VROf1onVO47cHnhrTU"

try(read_gsheets(ss = sheet_id)) # error, column types mismatch

read_gsheets(ss = sheet_id, col_types = "c")

\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=read_sheet]{read_sheet()}} which reads a Google (spread)Sheet into a data frame.
}
