% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRNfuns.R
\name{get_link_list_rename}
\alias{get_link_list_rename}
\title{Convert the adjacency matrix to network links}
\usage{
get_link_list_rename(weightMat, plotConnections)
}
\arguments{
\item{weightMat}{the (weighted) adjacency matrix - regulators in rows,
targets in columns}

\item{plotConnections}{the number of connections to subset to}
}
\value{
A data frame with fields from, to and value, describing the edges
of the network
}
\description{
This function converts an adjacency matrix to a data frame
of network links, subset to the most important ones.
}
\examples{
weightMat <- matrix(
  c(0.1, 0.4, 0.8, 0.3), nrow = 2, ncol = 2,
  dimnames = list("regulators" = c("r1", "r2"), "targets" = c("t1", "t2"))
)
get_link_list_rename(weightMat, 2)
}
