% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btergm.R
\name{createBtergm}
\alias{createBtergm}
\title{Constructor for \linkS4class{btergm} objects}
\usage{
createBtergm(
  coef,
  boot,
  R,
  nobs,
  time.steps,
  formula,
  formula2,
  response,
  effects,
  weights,
  auto.adjust,
  offset,
  directed,
  bipartite,
  nvertices,
  data
)
}
\arguments{
\item{coef}{Object of class \code{"numeric"}. The coefficients.}

\item{boot}{Object of class \code{"matrix"}. The bootstrapping sample.}

\item{R}{Object of class \code{"numeric"}. Number of replications.}

\item{nobs}{Object of class \code{"numeric"}. Number of observations.}

\item{time.steps}{Object of class \code{"numeric"}. Number of time steps.}

\item{formula}{Object of class \code{"formula"}. The original model formula
(without indices for the time steps).}

\item{formula2}{The revised formula with the object references after applying
the \code{\link{tergmprepare}} function.}

\item{response}{Object of class \code{"integer"}. The response variable.}

\item{effects}{Object of class \code{"data.frame"}. The effects that went
into the \code{glm} call.}

\item{weights}{Object of class \code{"integer"}. The weights of the
observations.}

\item{auto.adjust}{Object of class \code{"logical"}. Indicates whether
automatic adjustment of dimensions was done before estimation.}

\item{offset}{Object of class \code{"logical"}. Indicates whether an offset
matrix with structural zeros was used.}

\item{directed}{Object of class \code{"logical"}. Are the dependent networks
directed?}

\item{bipartite}{Object of class \code{"logical"}. Are the dependent networks
bipartite?}

\item{nvertices}{Number of vertices.}

\item{data}{The data after processing by the \code{\link{tergmprepare}}
function.}
}
\description{
Constructor for \linkS4class{btergm} objects.
}
\details{
Create an S4 \linkS4class{btergm} object using this constructor function.
}
\seealso{
Other tergm-classes: 
\code{\link{btergm-class}},
\code{\link{createMtergm}()},
\code{\link{createTbergm}()},
\code{\link{mtergm-class}},
\code{\link{tbergm-class}}
}
\author{
Philip Leifeld
}
\concept{tergm-classes}
