% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PosteriorFitted}
\alias{summary.PosteriorFitted}
\title{Provides posterior summary of variables' fitted values}
\usage{
\method{summary}{PosteriorFitted}(object, ...)
}
\arguments{
\item{object}{an object of class PosteriorFitted obtained using the
\code{compute_fitted_values()} function containing draws the predictive 
density of the sample data.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean, standard deviations, as well as 
5 and 95 percentiles of the fitted values for each of the shocks and periods.
}
\description{
Provides posterior summary of the fitted values including their 
mean, standard deviations, as well as 5 and 95 percentiles.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar$new(us_fiscal_lsuw)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20, thin = 1)

# compute fitted values
fitted         = compute_fitted_values(posterior)
fitted_summary = summary(fitted)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new() |>
  estimate(S = 10) |> 
  estimate(S = 20, thin = 1) |> 
  compute_fitted_values() |>
  summary() -> fitted_summary

}
\seealso{
\code{\link{compute_fitted_values}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
