% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particle_smoother.R
\name{particle_smoother}
\alias{particle_smoother}
\alias{particle_smoother.nongaussian}
\alias{particle_smoother.ssm_nlg}
\alias{particle_smoother.ssm_sde}
\title{Particle Smoothing}
\usage{
particle_smoother(model, nsim, ...)

\method{particle_smoother}{nongaussian}(
  model,
  nsim,
  method = "psi",
  seed = sample(.Machine$integer.max, size = 1),
  max_iter = 100,
  conv_tol = 1e-08,
  ...
)

\method{particle_smoother}{ssm_nlg}(
  model,
  nsim,
  method = "psi",
  seed = sample(.Machine$integer.max, size = 1),
  max_iter = 100,
  conv_tol = 1e-08,
  iekf_iter = 0,
  ...
)

\method{particle_smoother}{ssm_sde}(
  model,
  nsim,
  L,
  seed = sample(.Machine$integer.max, size = 1),
  ...
)
}
\arguments{
\item{model}{Model.}

\item{nsim}{Number of samples.}

\item{...}{Ignored.}

\item{method}{Choice of particle filter algorithm. 
For Gaussian and non-Gaussian models with linear dynamics,
options are \code{"bsf"} (bootstrap particle filter) 
and \code{"psi"} (\eqn{\psi}{psi}-APF, the default), and 
for non-linear models options \code{"ekf"} (extended Kalman particle filter) 
is also available.}

\item{seed}{Seed for RNG.}

\item{max_iter}{Maximum number of iterations used in Gaussian approximation. Used \eqn{\psi}{psi}-APF.}

\item{conv_tol}{Tolerance parameter used in Gaussian approximation. Used \eqn{\psi}{psi}-APF.}

\item{iekf_iter}{If zero (default), first approximation for non-linear 
Gaussian models is obtained from extended Kalman filter. If 
\code{iekf_iter > 0}, iterated extended Kalman filter is used with 
\code{iekf_iter} iterations.}

\item{L}{Integer defining the discretization level.}
}
\description{
Function \code{particle_smoother} performs filter-smoother or forward-backward smoother,
using a either bootstrap filtering or psi-auxiliary filter with stratification resampling.
}
