% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.postmean.bspcov.R
\name{plot.postmean.bspcov}
\alias{plot.postmean.bspcov}
\title{Draw a Heat Map for Point Estimate of Covariance Matrix}
\usage{
\method{plot}{postmean.bspcov}(x, ...)
}
\arguments{
\item{x}{an object from \strong{estimate}.}

\item{...}{additional arguments for ggplot2.}
}
\value{
\item{plot}{a heatmap for point estimate of covariance matrix \strong{x}.}
}
\description{
Provides a heat map for posterior mean estimate of sparse covariance matrix
}
\examples{

n <- 25
p <- 50
Sigma0 <- diag(1, p)
X <- MASS::mvrnorm(n = n, mu = rep(0, p), Sigma = Sigma0)
res <- bspcov::thresPPP(X, eps=0.01, thres=list(value=0.5,fun='hard'), nsample=100)
est <- bspcov::estimate(res)
plot(est)

}
\seealso{
estimate
}
\author{
Seongil Jo
}
