% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-functions.R
\name{bs4InsertTab}
\alias{bs4InsertTab}
\title{Insert a \link{bs4TabPanel} in a \link{bs4TabSetPanel}}
\usage{
bs4InsertTab(
  inputId,
  tab,
  target,
  position = c("before", "after"),
  select = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{\link{bs4TabSetPanel} id.}

\item{tab}{\link{bs4TabPanel} to insert.}

\item{target}{\link{bs4TabPanel} after of before which the new tab will be inserted.}

\item{position}{Insert before or after: \code{c("before", "after")}.}

\item{select}{Whether to select the newly inserted tab. FALSE by default.}

\item{session}{Shiny session object.}
}
\description{
Insert a \link{bs4TabPanel} in a \link{bs4TabSetPanel}
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 ui <-  bs4DashPage(
   sidebar_collapsed = T,
   sidebar = bs4DashSidebar(),
   bs4DashFooter(),
   body = bs4DashBody(
     actionButton("add1","ADD tabset 1"),
     bs4TabSetPanel(
       id = "tabset1", 
       side = "left",
       bs4TabPanel(
         tabName = "Tab 1",
         active = TRUE,
         p("Text 1"),
       ),
       bs4TabPanel(
         tabName = "Tab 2",
         active = FALSE,
         p("Text 2"),
       )
     ),
     actionButton("add2","ADD tabset 2"),
     bs4TabSetPanel(
       id = "tabset2", 
       side = "left",
       bs4TabPanel(
         tabName = "Tab 1",
         active = TRUE,
         p("Text 1"),
       ),
       bs4TabPanel(
         tabName = "Tab 2",
         active = FALSE,
         p("Text 2"),
       )
     )
   )
 )
 
 server <- function(input, output, session) {
   
   observeEvent(input$add1, {
     bs4InsertTab(
       inputId = "tabset1",
       bs4TabPanel(tabName = "Dynamic", "I am inserted"),
       target = "Tab 1",
       position = "after",
       select = FALSE
     )
   })
   
   observeEvent(input$add2, {
     bs4InsertTab(
       inputId = "tabset2",
       bs4TabPanel(tabName = "Dynamic", "I am inserted and active"),
       target = "Tab 1",
       position = "before",
       select = TRUE
     )
   })
   
 }
 shinyApp(ui, server)
}
}
