% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bomega.R
\name{bomega}
\alias{bomega}
\title{bomega: Bayesian Estimation of Coefficient Omega}
\usage{
bomega(K, mod, alpha, beta, CI)
}
\arguments{
\item{K}{The number of test items.}

\item{mod}{A measurement model estimated as a bsem object by blavaan.}

\item{alpha}{Prior true score variance.}

\item{beta}{Prior error variance.}

\item{CI}{Credible interval quantile, as a decimal (ie, for 95 percent, 0.95).}
}
\value{
Returns estimated median and quantile based credible limits for omega.
}
\description{
This function estimates coefficient omega internal consistency reliability.
}
\examples{

\donttest{
your_data=data.frame(mvrnorm(n=20,mu=c(0,0,0,0,0),
Sigma=matrix(c(4,2,2,2,2,
              2,4,2,2,2,
              2,2,4,2,2,
              2,2,2,4,2,
              2,2,2,2,4),
            nrow=5, ncol=5)))
colnames(your_data)=c("x1","x2","x3","x4","x5")
mod='tau=~x1+x2+x3+x4+x5'
fit=bsem(mod,data=your_data)
bomega(K=5,mod=mod,alpha=3.51,beta=1.75,CI=0.95)}

}
