% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_02_scale.R
\name{\%\%COMPUTE\%\%}
\alias{\%\%COMPUTE\%\%}
\alias{COUNT}
\alias{MODE}
\alias{SUM}
\alias{MEAN}
\alias{STD}
\alias{CONSEC}
\title{Multivariate computation.}
\usage{
COUNT(data, var = NULL, items = NULL, vars = NULL, varrange = NULL, value = NA)

MODE(data, var = NULL, items = NULL, vars = NULL, varrange = NULL)

SUM(
  data,
  var = NULL,
  items = NULL,
  vars = NULL,
  varrange = NULL,
  rev = NULL,
  likert = NULL,
  na.rm = TRUE
)

MEAN(
  data,
  var = NULL,
  items = NULL,
  vars = NULL,
  varrange = NULL,
  rev = NULL,
  likert = NULL,
  na.rm = TRUE
)

STD(
  data,
  var = NULL,
  items = NULL,
  vars = NULL,
  varrange = NULL,
  rev = NULL,
  likert = NULL,
  na.rm = TRUE
)

CONSEC(
  data,
  var = NULL,
  items = NULL,
  vars = NULL,
  varrange = NULL,
  values = 0:9
)
}
\arguments{
\item{data}{Data frame.}

\item{var}{\strong{[option 1]}
Common part across multiple variables (e.g., \code{"RSES", "SWLS"}).}

\item{items}{\strong{[option 1]}
Unique part across multiple variables (e.g., \code{1:10}).}

\item{vars}{\strong{[option 2]}
Character vector specifying a variable list (e.g., \code{c("E1", "E2", "E3", "E4", "E5")}).}

\item{varrange}{\strong{[option 3]}
Character with \code{":"} specifying the start and end positions of a variable list (e.g., \code{"A1:E5"}).}

\item{value}{[only for \code{COUNT}] The value to be counted.}

\item{rev}{[optional] Reverse-scoring variables. It can be
(1) a numeric vector specifying the positions of reverse-scoring variables (not recommended) or
(2) a character vector directly specifying the variable list (recommended).}

\item{likert}{[optional] Range of likert scale (e.g., \code{1:5}, \code{c(1, 5)}).
If not provided, it will be automatically estimated from the given data (BUT you should use this carefully).}

\item{na.rm}{Ignore missing values. Default is \code{TRUE}.}

\item{values}{[only for \code{CONSEC}] Values to be counted as consecutive identical values. Default is all numbers (\code{0:9}).}
}
\value{
A vector of computed values.
}
\description{
Easily compute multivariate sum, mean, and other scores.
Reverse scoring can also be easily implemented without saving extra variables.
\code{\link{Alpha}} function uses a similar method to deal with reverse scoring.

Three options to specify the variable list:
\enumerate{
  \item \strong{\code{var + items}}: use the common and unique parts of variable names.
  \item \strong{\code{vars}}: directly define a variable list.
  \item \strong{\code{varrange}}: use the start and end positions of a variable list.
}
}
\section{Functions}{
\itemize{
\item \code{COUNT}: \strong{Count} a certain value across multiple variables.

\item \code{MODE}: Compute \strong{mode} across multiple variables.

\item \code{SUM}: Compute \strong{sum} across multiple variables.

\item \code{MEAN}: Compute \strong{mean} across multiple variables.

\item \code{STD}: Compute \strong{standard deviation} across multiple variables.

\item \code{CONSEC}: Compute \strong{consecutive identical digits} across multiple variables (especially useful in detecting careless responding).
}}

\examples{
d=data.table(x1=1:5,
             x4=c(2,2,5,4,5),
             x3=c(3,2,NA,NA,5),
             x2=c(4,4,NA,2,5),
             x5=c(5,4,1,4,5))
d
## I deliberately set this order to show you
## the difference between "vars" and "varrange".

d[,`:=`(
  na=COUNT(d, "x", 1:5, value=NA),
  n.2=COUNT(d, "x", 1:5, value=2),
  sum=SUM(d, "x", 1:5),
  m1=MEAN(d, "x", 1:5),
  m2=MEAN(d, vars=c("x1", "x4")),
  m3=MEAN(d, varrange="x1:x2", rev="x2", likert=1:5),
  cons1=CONSEC(d, "x", 1:5),
  cons2=CONSEC(d, varrange="x1:x5")
)]
d

data=as.data.table(bfi)
data[,`:=`(
  E=MEAN(d, "E", 1:5, rev=c(1,2), likert=1:6),
  O=MEAN(d, "O", 1:5, rev=c(2,5), likert=1:6)
)]
data

}
