% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy}
\alias{tidy}
\title{Retrieve tidy dataframe if it exists.}
\usage{
tidy(x, ...)
}
\arguments{
\item{x}{An object to be converted into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}.}

\item{...}{Additional arguments to tidying method.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with information about model components.
}
\description{
Checks if a \code{tidy} method exits for a given object, either in
\code{broom} or in \code{broom.mixed}. If it does, it turn an object into a tidy
tibble, if not, return a \code{NULL}.
}
\section{Methods}{


\Sexpr[stage=render,results=rd]{generics:::methods_rd("tidy")}

}

\examples{
set.seed(123)
library(lme4)

# mixed-effects models (`broom.mixed` will be used)
lmm.mod <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
broomExtra::tidy(lmm.mod, effects = "fixed", exponentiate = TRUE)

# linear model (`broom` will be used)
lm.mod <- lm(Reaction ~ Days, sleepstudy)
broomExtra::tidy(lm.mod, conf.int = TRUE)
}
\author{
Indrajeet Patil
}
