% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{augment_columns}
\alias{augment_columns}
\title{Add fitted values, residuals, and other common outputs to
an augment call}
\usage{
augment_columns(
  x,
  data,
  newdata = NULL,
  type,
  type.predict = type,
  type.residuals = type,
  se.fit = TRUE,
  ...
)
}
\arguments{
\item{x}{a model}

\item{data}{original data onto which columns should be added}

\item{newdata}{new data to predict on, optional}

\item{type}{Type of prediction and residuals to compute}

\item{type.predict}{Type of prediction to compute; by default
same as \code{type}}

\item{type.residuals}{Type of residuals to compute; by default
same as \code{type}}

\item{se.fit}{Value to pass to predict's \code{se.fit}, or NULL for
no value}

\item{...}{extra arguments (not used)}
}
\description{
\code{augment_columns} is intended for use in the internals of \code{augment} methods
only and is exported for developers extending the broom package. Please
instead use \code{\link[=augment]{augment()}} to appropriately make use of the functionality
in \code{augment_columns()}.
}
\details{
Note that, in the case that a \code{residuals()} or \code{influence()} generic is
not implemented for the supplied model \code{x}, the function will fail quietly.
}
