% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ks-tidiers.R
\name{tidy.kde}
\alias{tidy.kde}
\alias{kde_tidiers}
\alias{ks_tidiers}
\title{Tidy a(n) kde object}
\usage{
\method{tidy}{kde}(x, ...)
}
\arguments{
\item{x}{A \code{kde} object returned from \code{\link[ks:kde]{ks::kde()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.level = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
Returns a data frame in long format with four columns. Use
\code{tidyr::pivot_wider(..., names_from = variable, values_from = value)}
on the output to return to a wide format.
}
\examples{

library(ks)

dat <- replicate(2, rnorm(100))
k <- kde(dat)

td <- tidy(k)
td

library(ggplot2)
library(dplyr)
library(tidyr)

td \%>\%
  pivot_wider(c(obs, estimate),
    names_from = variable,
    values_from = value
  ) \%>\%
  ggplot(aes(x1, x2, fill = estimate)) +
  geom_tile() +
  theme_void()

# also works with 3 dimensions
dat3 <- replicate(3, rnorm(100))
k3 <- kde(dat3)

td3 <- tidy(k3)
td3
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[ks:kde]{ks::kde()}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{estimate}{The estimated value of the regression term.}
  \item{obs}{weighted observed number of events in each group.}
  \item{value}{The value/estimate of the component. Results from data reshaping.}
  \item{variable}{Variable under consideration.}

}
