% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_tidiers.R
\name{tidy_parameters}
\alias{tidy_parameters}
\title{Tidy a model with parameters package}
\usage{
tidy_parameters(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{(a model object, e.g. \code{glm})\cr
A model to be tidied.}

\item{conf.int}{(\code{logical})\cr
Whether or not to include a confidence interval in the tidied output.}

\item{conf.level}{(\code{numeric})\cr
The confidence level to use for the confidence interval (between \code{0} ans \code{1}).}

\item{...}{Additional parameters passed to \code{\link[parameters:model_parameters]{parameters::model_parameters()}}.}
}
\description{
Use \code{\link[parameters:model_parameters]{parameters::model_parameters()}} to tidy a model and apply
\code{parameters::standardize_names(style = "broom")} to the output
}
\note{
For \code{\link[betareg:betareg]{betareg::betareg()}}, the component column in the results is standardized
with \code{\link[broom:reexports]{broom::tidy()}}, using \code{"mean"} and \code{"precision"} values.
}
\examples{
\dontshow{if (.assert_package("parameters", boolean = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
  lm(Sepal.Length ~ Sepal.Width + Species, data = iris) |>
    tidy_parameters()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other custom_tieders: 
\code{\link{tidy_broom}()},
\code{\link{tidy_multgee}()},
\code{\link{tidy_svy_vglm}()},
\code{\link{tidy_vgam}()},
\code{\link{tidy_with_broom_or_parameters}()},
\code{\link{tidy_zeroinfl}()}
}
\concept{custom_tieders}
