% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigrid.R
\name{trigrid}
\alias{trigrid}
\title{Add grid lines to triplot}
\usage{
trigrid(
  n = 1,
  col = "white",
  lty = 1,
  lwd = 1,
  outer_col = "black",
  outer_lwd = 2,
  ...
)
}
\arguments{
\item{n}{Number of grid lines}

\item{col}{Color of grid lines}

\item{lty}{Line type for grid lines}

\item{lwd}{Line width of grid lines}

\item{outer_col}{Color of outer triangle (If NULL, not plotted)}

\item{outer_lwd}{Line width of outer triangle}

\item{...}{Additional arguments passed to \code{\link[=trilines]{trilines()}}}
}
\description{
Add grid lines to a ternary plot with \code{\link[=triplot]{triplot()}}
}
\examples{
triplot(c("A","H","B"), gridlines=1, grid_lwd=2)
trigrid(3, lty=2, lwd=2)
}
\seealso{
\code{\link[=triplot]{triplot()}}, \code{\link[=trilines]{trilines()}}
}
