% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.brokenstick}
\alias{plot.brokenstick}
\title{Plot observed and fitted trajectories by group}
\usage{
\method{plot}{brokenstick}(x, newdata = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{brokenstick}.}

\item{newdata}{Optional. A data frame in which to look for variables with
which to predict. The training data are used if omitted and
if \code{object$light} is \code{FALSE}.}

\item{...}{Extra arguments passed down to \code{\link[=predict.brokenstick]{predict.brokenstick()}}
and \code{\link[=plot_trajectory]{plot_trajectory()}}.}
}
\value{
An object of class \link[ggplot2:ggplot]{ggplot2::ggplot}.
}
\description{
The \code{plot} method for a \code{brokenstick} object plots the observed and
fitted trajectories of one or more groups.
}
\details{
By default, \code{plot(fit)} will plot the observed and fitted data for the
first three groups in the data. The default setting drops the fitted value
at the right boundary knot from the display.
}
\examples{
\dontrun{
# fit model on raw hgt with knots at 0, 1, 2 and 3 years
fit1 <- brokenstick(hgt ~ age | id, smocc_200, knots = 0:2)
gp <- c(10001, 10005, 10022)
plot(fit1, group = gp, xlab = "Age (years)", ylab = "Length (cm)")

# fit model on standard deviation score
fit2 <- brokenstick(hgt_z ~ age | id, smocc_200, knots = 0:2)
plot(fit2, group = gp, xlab = "Age (years)", ylab = "Length (SDS)")

# built-in model with 11 knots
plot(fit_200, group = gp, xlab = "Age (years)", ylab = "Length (SDS)")

# black and white version
plot(fit_200, group = gp, xlab = "Age (years)", ylab = "Length (SDS)",
    color_y = rep("black", 2), shape_y = 1, linetype_y = 3,
    color_yhat = rep("grey20", 2), shape_yhat = NA)
}
}
\seealso{
\link{predict.brokenstick}, \link{plot_trajectory}.
}
\author{
Stef van Buuren 2021
}
