% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libraries.R
\name{db_libs_all_cluster_statuses}
\alias{db_libs_all_cluster_statuses}
\title{Get Status of All Libraries on All Clusters}
\usage{
db_libs_all_cluster_statuses(
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Get Status of All Libraries on All Clusters
}
\details{
A status will be available for all libraries installed on clusters via the
API or the libraries UI as well as libraries set to be installed on all
clusters via the libraries UI.

If a library has been set to be installed on all clusters,
\code{is_library_for_all_clusters} will be true, even if the library was
also installed on this specific cluster.
}
\seealso{
Other Libraries API: 
\code{\link{db_libs_cluster_status}()},
\code{\link{db_libs_install}()},
\code{\link{db_libs_uninstall}()}
}
\concept{Libraries API}
