% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execution-context.R
\name{db_context_command_run}
\alias{db_context_command_run}
\title{Run a Command}
\usage{
db_context_command_run(
  cluster_id,
  context_id,
  language = c("python", "sql", "scala", "r"),
  command = NULL,
  command_file = NULL,
  options = list(),
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{cluster_id}{The ID of the cluster to create the context for.}

\item{context_id}{The ID of the execution context.}

\item{language}{The language for the context. One of \code{python}, \code{sql}, \code{scala},
\code{r}.}

\item{command}{The command string to run.}

\item{command_file}{The path to a file containing the command to run.}

\item{options}{Named list of values used downstream. For example, a
'displayRowLimit' override (used in testing).}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Run a Command
}
\seealso{
Other Execution Context API: 
\code{\link{db_context_command_cancel}()},
\code{\link{db_context_command_parse}()},
\code{\link{db_context_command_run_and_wait}()},
\code{\link{db_context_command_status}()},
\code{\link{db_context_create}()},
\code{\link{db_context_destroy}()},
\code{\link{db_context_status}()}
}
\concept{Execution Context API}
