% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-connector.R
\name{db_sql_client}
\alias{db_sql_client}
\title{Create Databricks SQL Connector Client}
\usage{
db_sql_client(
  id,
  catalog = NULL,
  schema = NULL,
  compute_type = c("warehouse", "cluster"),
  use_cloud_fetch = FALSE,
  session_configuration = list(),
  host = db_host(),
  token = db_token(),
  workspace_id = db_current_workspace_id(),
  ...
)
}
\arguments{
\item{id}{String, ID of either the SQL warehouse or all purpose cluster.
Important to set \code{compute_type} to the associated type of \code{id}.}

\item{catalog}{Initial catalog to use for the connection. Defaults to \code{NULL}
in which case the default catalog will be used.}

\item{schema}{Initial schema to use for the connection. Defaults to \code{NULL}
in which case the default catalog will be used.}

\item{compute_type}{One of \code{"warehouse"} (default) or \code{"cluster"}, corresponding to
associated compute type of the resource specified in \code{id}.}

\item{use_cloud_fetch}{Boolean (default is \code{FALSE}). \code{TRUE} to send fetch
requests directly to the cloud object store to download chunks of data.
\code{FALSE} to send fetch requests directly to Databricks.

If \code{use_cloud_fetch} is set to \code{TRUE} but network access is blocked, then
the fetch requests will fail.}

\item{session_configuration}{A optional named list of Spark session
configuration parameters. Setting a configuration is equivalent to using the
\verb{SET key=val} SQL command.
Run the SQL command \code{SET -v} to get a full list of available configurations.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{workspace_id}{String, workspace Id used to build the http path for the
connection. This defaults to using \code{\link[=db_wsid]{db_wsid()}} to get \code{DATABRICKS_WSID}
environment variable. Not required if \code{compute_type} is \code{"cluster"}.}

\item{...}{passed onto \code{\link[=DatabricksSqlClient]{DatabricksSqlClient()}}.}
}
\value{
\code{\link[=DatabricksSqlClient]{DatabricksSqlClient()}}
}
\description{
Create Databricks SQL Connector Client
}
\details{
Create client using Databricks SQL Connector.
}
\examples{
\dontrun{
  client <- db_sql_client(id = "<warehouse_id>", use_cloud_fetch = TRUE)
}
}
