% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_dist.R
\name{Graph Distances}
\alias{Graph Distances}
\alias{edge_spatial_dist}
\alias{vertex_spatial_dist}
\title{Calculate Euclidean distance of edges and vertices}
\usage{
edge_spatial_dist(g)

vertex_spatial_dist(g)
}
\arguments{
\item{g}{An \code{igraph} graph object}
}
\value{
\code{edge_spatial_dist} - a numeric vector with length equal to the
  edge count of the input graph, consisting of the Euclidean distance (in
  \emph{mm}) of each edge

\code{vertex_spatial_dist} - a named numeric vector with length equal
  to the number of vertices, consisting of the average distance (in
  \emph{mm}) for each vertex
}
\description{
\code{edge_spatial_dist} calculates the Euclidean distance of an
\code{igraph} graph object's edges. The distances are in \emph{mm} and based
on MNI space. These distances are \emph{NOT} along the cortical surface, so
can only be considered approximations, particularly concerning
inter-hemispheric connections. The input graph must have \emph{atlas} as a
graph-level attribute.

\code{vertex_spatial_dist} calculates, for each vertex of a graph, the
average Euclidean distance across all of that vertex's connections.
}
\references{
Alexander-Bloch, A.F. and Vertes, P.E. and Stidd, R. et al.
  (2013) The anatomical distance of functional connections predicts brain
  network topology in health and schizophrenia. \emph{Cerebral Cortex},
  \bold{23}, 127--138. \url{https://dx.doi.org/10.1093/cercor/bhr388}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
