% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individ_contrib.R
\name{IndividualContributions}
\alias{IndividualContributions}
\alias{loo}
\alias{aop}
\title{Approaches to estimate individual network contribution}
\usage{
loo(resids, corrs, level = c("global", "regional"))

aop(resids, corr.mat, level = c("global", "regional"), control.value = 1)
}
\arguments{
\item{resids}{An object of class \code{brainGraph_resids} (the output from
\code{\link{get.resid}})}

\item{corrs}{List of lists of correlation matrices (as output by
\code{\link{corr.matrix}}).}

\item{level}{Character string; the level at which you want to calculate
contributions (either \code{global} or \code{regional})}

\item{corr.mat}{Numeric; correlation matrix of the \emph{control} group}

\item{control.value}{Integer or character string specifying the control group
(default: 1)}
}
\value{
A \code{data.table} with columns for
  \item{Study.ID}{Subject identifier}
  \item{Group}{Group membership}
  \item{region}{If \code{level='regional'}}
  \item{IC,RC}{The value of the individual/regional contributions}
}
\description{
\code{loo} calculates the individual contribution to group network data for
each subject in each group using a "leave-one-out" approach. The residuals of
a single subject are excluded, and a correlation matrix is created. This is
compared to the original correlation matrix using the Mantel test.

\code{aop} calculates the individual contribution using an "add-one-patient"
approach. The residuals of a single patient are added to those of a control
group, and a correlation matrix is created. This is repeated for all
individual patients and each patient group.
}
\examples{
\dontrun{
IC <- loo(resids.all, corrs)
RC <- loo(resids.all, corrs, level='regional')
}
\dontrun{
IC <- aop(resids.all, corrs[[1]]$R)
RC <- aop(resids.all, corrs[[1]]$R, level='regional')
}
}
\references{
Saggar M., Hosseini S.M.H., Buno J.L., Quintin E., Raman M.M.,
  Kesler S.R., Reiss A.L. (2015) \emph{Estimating individual contributions
  from group-based structural correlations networks}. NeuroImage, 120:274-284.
  doi:10.1016/j.neuroimage.2015.07.006
}
\seealso{
Other Structural covariance network functions: \code{\link{brainGraph_boot}},
  \code{\link{brainGraph_init}},
  \code{\link{brainGraph_permute}},
  \code{\link{corr.matrix}}, \code{\link{get.resid}},
  \code{\link{plot.brainGraph_resids}},
  \code{\link{plot_volumetric}}

Other Group analysis functions: \code{\link{NBS}},
  \code{\link{brainGraph_GLM}},
  \code{\link{brainGraph_boot}},
  \code{\link{brainGraph_mediate}},
  \code{\link{brainGraph_permute}}, \code{\link{mtpc}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
