% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_resid.R
\name{get.resid}
\alias{get.resid}
\title{Linear models of columns of a data frame}
\usage{
get.resid(thicknesses, covars)
}
\arguments{
\item{thicknesses}{Data frame of all thickness data. First column must be
subject ID (or something similar)}

\item{covars}{Data frame of covariates for the linear model. Must share a
subject ID column with \emph{thicknesses}}
}
\value{
A list with components:
\item{models}{The \code{\link[stats]{lm}} objects for each brain region.}
\item{resids}{Data table of studentized residuals for all subjects and brain
regions.}
}
\description{
This function runs linear models on the columns of the input data frame (e.g.
cortical thickness data for each region), in order to adjust for relevant
variables (e.g. age, sex, group, etc.).
}
\seealso{
\code{\link{rstudent}}
}

