% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{qrnegLogLikeOR2}
\alias{qrnegLogLikeOR2}
\title{Negative sum of log-likelihood in the OR2 model}
\usage{
qrnegLogLikeOR2(y, x, gammacp, betaOne, sigmaOne, p)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{gammacp}{a row vector of cutpoints including (-Inf, Inf).}

\item{betaOne}{a sample draw of \eqn{\beta} of size \eqn{(k x 1)}.}

\item{sigmaOne}{a sample draw of \eqn{\sigma}, a scalar value.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns the negative sum of log-likelihood.
}
\description{
This function computes the negative sum of log-likelihood in the OR2 model (ordinal quantile
model with exactly 3 outcomes).
}
\details{
This function computes the negative sum of log-likelihood in the OR2 model where the error is assumed to follow
an AL distribution.
}
\examples{
set.seed(101)
data("data25j3")
y <- data25j3$y
xMat <- data25j3$x
p <- 0.25
gammacp <- c(-Inf, 0, 3, Inf)
betaOne <- c(1.810504, 1.850332, 6.18116)
sigmaOne <- 0.9684741
output <- qrnegLogLikeOR2(y, xMat, gammacp, betaOne, sigmaOne, p)

# output
#   902.4045

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
}
\seealso{
likelihood maximization
}
