% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{qrnegloglikensum}
\alias{qrnegloglikensum}
\title{Negative log-likelihood for Ordinal Models with more than 3 outcomes}
\usage{
qrnegloglikensum(deltain, y, x, beta, p)
}
\arguments{
\item{deltain}{initialization of cut-points.}

\item{y}{dependent variable i.e. ordinal outcome values.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{beta}{column vector of coeffcients of dimension \eqn{(k x 1)}.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components
\itemize{
\item{\code{nlogl}: }{a vector with likelihood values.}
\item{\code{negsumlogl}: }{a scalar with value of negative log-likelihood.}
}
}
\description{
Function for calculating negative log-likelihood for Ordinal models with
more than 3 outcomes.
}
\details{
Computes the negtaive of the log-likelihood function using the
asymmetric Laplace distribution over the iid random
variables.
}
\examples{
set.seed(101)
deltain <- c(-0.9026915, -2.2488833)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
p <- 0.25
beta <- c(-1.429465, 1.135585, 2.107666)
ans <- qrnegloglikensum(deltain, y, x, beta, p)

# nlogl
#   3.36678284
#   2.66584712
#   0.52085599
#   0.60451039
#   0.58008590
#   0.18984750
#   2.79497033
#   1.03255169
#   0.12144529
#   0.55554991... soon

# negsumlogl
#   283.1566

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.
}
\seealso{
likelihood maximization
}
