# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute a mean resultant length
#'
#' @param theta a circular variable in radians.
#'
#' @keywords internal
#'
rho <- function(theta) {
    .Call(`_bpnreg_rho`, theta)
}

#' Compute a mean direction
#'
#' @inheritParams rho
#'
#' @keywords internal
#'
theta_bar <- function(theta) {
    .Call(`_bpnreg_theta_bar`, theta)
}

#' Compute Eigenvalues
#'
#' @param X A matrix.
#'
#' @keywords internal
#'
eigen_val <- function(X) {
    .Call(`_bpnreg_eigen_val`, X)
}

#' Compute Eigenvectors
#'
#' @inheritParams eigen_val
#'
#' @keywords internal
#'
eigen_vec <- function(X) {
    .Call(`_bpnreg_eigen_vec`, X)
}

#' Sample from a multivariate normal distribution
#'
#' @param sigma A variance-covariance matrix.
#' @param mu A mean vector.
#' @param n An integer indicating the number of samples to take.
#'
#' @keywords internal
#'
mvrnorm_arma_eigen <- function(n, mu, sigma) {
    .Call(`_bpnreg_mvrnorm_arma_eigen`, n, mu, sigma)
}

#' Compute circular coefficients
#'
#' @param a1 intercept estimate of component I.
#' @param a2 intercept estimate of component I.
#' @param b1 slope estimate of component I.
#' @param b2 slope estimate of component I.
#'
#' @keywords internal
#'
circ_coef_rcpp <- function(a1, a2, b1, b2) {
    .Call(`_bpnreg_circ_coef_rcpp`, a1, a2, b1, b2)
}

#' Compute the Likelihood of the PN distribution
#'
#' @param X1 the model matrix of the first component
#' @param X2 the model matrix of the second component
#' @param theta a circular outcome value
#' @param b1 estimated linear coefficients of the first component
#' @param b2 estimated linear coefficients of the second component
#' @param n sample size
#'
#' @keywords internal
#'
lik <- function(X1, X2, theta, b1, b2, n) {
    .Call(`_bpnreg_lik`, X1, X2, theta, b1, b2, n)
}

#' Compute Model Fit Measures Regression Model
#'
#' @param Output output from the circular regression function Regression()
#' @param X1 model matrix for the first component
#' @param X2 model matrix for the second component
#'
#' @keywords internal
#'
DIC_reg <- function(Output, X1, X2) {
    .Call(`_bpnreg_DIC_reg`, Output, X1, X2)
}

#' A slice sampler for the latent lengths r
#'
#' @param X1 A model matrix for component I.
#' @param X2 A model matrix for component II.
#' @param theta A vector with the circular dependent variable.
#' @param b1 A matrix containing the coefficients of component I for the current iteration.
#' @param b2 A matrix containing the coefficients of component II for the current iteration.
#' @param n An integer indicating the sample size of the data.
#' @param r A matrix with the estimates of r of the previous iteration.
#'
#' @keywords internal
#'
slice_rcpp <- function(X1, X2, theta, b1, b2, n, r) {
    .Call(`_bpnreg_slice_rcpp`, X1, X2, theta, b1, b2, n, r)
}

#' A Gibbs sampler for a projected normal regression model
#'
#' @param theta A vector with the circular dependent variable.
#' @param X1r A model matrix for component I.
#' @param X2r A model matrix for component II.
#' @param its An integer specifying the number of iterations
#' @param lag An integer specifying the amount of lag.
#' @param burn An integer specifying the number of burn-in iterations.
#'
#' @keywords internal
#'
pnr <- function(theta, X1r, X2r, its, lag, burn) {
    .Call(`_bpnreg_pnr`, theta, X1r, X2r, its, lag, burn)
}

#' Estimate the mode by finding the highest posterior density interval
#'
#' @param x a  sample from which to estimate the interval
#' @param cip bandwidth for the algorithm, ranging from 0 to 1
#'
#' @return a scalar containing the estimate of the mode
#'
#' @keywords internal
#'
hmodeC <- function(x, cip) {
    .Call(`_bpnreg_hmodeC`, x, cip)
}

#' Find the highest density interval of a circular variable
#'
#' @inheritParams hmodeC
#'
#' @return a vector of length 2 containing the lower and upper bound of the interval
#'
#' @keywords internal
#'
hmodeciC <- function(x, cip) {
    .Call(`_bpnreg_hmodeciC`, x, cip)
}

#' Estimate the mode by finding the highest posterior density interval
#'
#' @inheritParams hmodeC
#'
#' @return a scalar containing the estimate of the mode
#'
#' @keywords internal
#'
hmode <- function(x, cip) {
    .Call(`_bpnreg_hmode`, x, cip)
}

#' Find the highest density interval.
#'
#' @inheritParams hmodeC
#' @inheritParams hmodeC
#'
#' @return a vector of length 2 containing the lower and upper bound of the interval.
#'
#' @keywords internal
#'
hmodeci <- function(x, cip) {
    .Call(`_bpnreg_hmodeci`, x, cip)
}

