% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{bpnme}
\alias{bpnme}
\title{Fit a Bayesian circular mixed-effects model}
\source{
Cremers, J., Mainhard, M.T. & Klugkist, I. (in press). Assessing a
  Bayesian Embedding Approach to Circular Regression Models. Methodology

Cremers, J., & Klugkist, I. (2017). How to analyze circular data: A
  tutorial for projected normal regression models. Under review.

Cremers, J., & Klugkist, I. (2017). Longitudinal circular modelling
  of circumplex measurements for teacher behavior. Working paper.

Nuñez-Antonio, G. & Gutiérrez-Peña, E. (2014). A Bayesian model for
  longitudinal circular data based on the projected normal distribution.
  Computational Statistics and Data Analysis, 71, 506-519.

Presnell, B., Morrison, S.P. & Littell, R.C. (1998). Projected
  multivariate linear models for directional data. Journal of the American
  Statistical Association, 93 (443), 1068 - 1077.
}
\usage{
bpnme(pred.I, data, pred.II = pred.I, its = 1000, burn = 1, n.lag = 1,
  seed = NULL)
}
\arguments{
\item{pred.I}{model equation for effects of component 1.}

\item{data}{the dataframe used for analysis.}

\item{pred.II}{model equation for effects of component 2.}

\item{its}{output iterations of the MCMC sampler.}

\item{burn}{number of burn-in iterations.}

\item{n.lag}{amount of lag for the iterations and burn-in.}

\item{seed}{user-specified random seed.}
}
\value{
A \code{bpnme} object, which can be further analyzed using the
  associated functions \code{\link{traceplot.bpnme}},
  \code{\link{BFc.bpnme}}, \code{\link{coef_lin.bpnme}},
  \code{\link{coef_circ.bpnme}}, \code{\link{coef_ran.bpnme}},
  \code{\link{residuals.bpnme}}, \code{\link{predict.bpnme}},
  \code{\link{fit.bpnme}} and \code{\link{print.bpnme}}.

  A \code{bpnr} object contains the following elements (some elements are not
  returned if not applicable)

  \describe{ \item{\code{Beta.I}}{A matrix of posterior samples for the fixed
  effects coefficients for the first component.} \item{\code{Beta.II}}{A
  matrix of posterior samples for the fixed effects coefficients for the
  second component.} \item{\code{B.I}}{An array of posterior samples for the
  random effects coefficients for the first component.} \item{\code{B.II}}{An
  array of posterior samples for the random effects coefficients for the
  second component.} \item{\code{VCovI}}{An array of posterior samples for
  the random effect variances of the first component.}
  \item{\code{VCovII}}{An array of posterior samples for the random effect
  variances of the second component.} \item{\code{predictiva}}{A list
  containing the posterior density values for all timepoints of individuals
  in the dataset for all iterations. The rowsums of this matrix are the
  likelihood values for all iterations} \item{\code{circular.ri}}{A vector of
  posterior samples for the circular random intercepts.}
  \item{\code{N}}{Number of observed cases.} \item{\code{its}}{Number of
  output iterations.} \item{\code{n.lag}}{One in \code{n.lag} iterations will
  be saved as output iteration. Set lag to 1 to save all iterations
  (default).} \item{\code{burn}}{Burn-in time for the MCMC sampler.}
  \item{\code{p1}}{Number of fixed effect parameters predicting the first
  component.} \item{\code{p2}}{Number of fixed effect parameters predicting
  the second component.} \item{\code{q1}}{Number of random effect parameters
  predicting the first component.} \item{\code{q2}}{Number of random effect
  parameters predicting the second component.} \item{\code{a.x}}{A matrix of
  posterior samples for \code{a.x} which describes the location of the
  inflection point of the regression curve on the axis of the predictor.}
  \item{\code{a.c}}{A matrix of posterior samples for \code{a.c} which
  describes the location of the inflection point of the regression curve on
  the axis of the circular outcome.} \item{\code{b.c}}{A matrix of posterior
  samples for \code{b.c} which describes the slope of the tangent line at the
  inflection point.} \item{\code{SAM}}{A matrix of posterior samples for the
  circular regression slopes at the mean.} \item{\code{AS}}{A matrix of
  posterior samples for the average slopes of the circular regression.}
  \item{\code{SSDO}}{A matrix of posterior samples for the signed shortest
  distance to the origin.} \item{\code{circ.diff}}{A matrix of posterior
  samples for the circular difference found between levels of categorical
  variables and the intercept.} \item{\code{cRSnum}}{A string indicating
  whether there are continuous variables with a random slope}
  \item{\code{cRScat}}{A string indicating whether there are categorical
  variables with a random slope} \item{\code{cRS}}{A string indicating
  whether there are categorical or continuous variables with a random slope}
  \item{\code{cRI}}{A vector of posterior samples of the mean resultant
  length of the circular random intercept, a measure of concentration.}
  \item{\code{Call}}{The matched call.} \item{\code{lin.coef.I}}{The mean,
  mode, standard deviation and 95 % confidence interval of the highest
  posterior density of the linear fixed effect coefficients for \code{B1}.}
  \item{\code{lin.coef.II}}{The mean, mode, standard deviation and 95 %
  confidence interval of the highest posterior density of the linear fixed
  effect coefficients for \code{B2}.} \item{\code{circ.coef}}{The mean, mode,
  standard deviation and 95 % confidence interval of the highest posterior
  density for \code{a.x}, \code{a.c}, \code{SSDO}, and the circular fixed
  effect coefficients \code{b.c}, \code{AS}, and \code{SAM}}
  \item{\code{circ.coef.cat}}{The mean, mode, standard deviation and 95 %
  confidence interval of the highest posterior density the circular
  difference between levels of categorical variables and the intercept.}
  \item{\code{circ.coef.means}}{The mean, mode, standard deviation and 95 %
  confidence interval of the highest posterior density of circular means of
  the categorical variables.} \item{\code{model.fit}}{A list of information
  criteria for assessment of model fit.} \item{\code{lin.res.varrand.I}}{The
  mean, mode, standard deviation and 95 % confidence interval of  the
  variances of the random intercepts and slopes of component I.}
  \item{\code{lin.res.varrand.II}}{The mean, mode, standard deviation and 95
  % confidence interval of the variances of the random intercepts and slopes
  of component II.} \item{\code{circ.res.varrand}}{The mean, mode, standard
  deviation and 95 % confidence interval of the circular variances of the
  random intercepts and slopes.} \item{\code{mm}}{A list of information,
  model matrices, sample size, etc. on the specified model.} }
}
\description{
This function fits a Bayesian circular mixed-effects model based on the
projected normal distribution.
}
\details{
Because the model is based on the projected normal distribution, a
  model equation has to be given for the fixed and random effects of the two
  components. By default the model equation of the second component
  \code{pred.II} is set to be equal to that of the first component. For more
  information about the projected normal distribution see Presnell, Morrisson
  & Littell (1998).

  A tutorial on how to use this function can be found in Cremers & Klugkist
  (2017, working paper). More details on the sampling algorithm and
  interpretation of the coefficients from the model can be found in
  Nuñez-Antonio & Guttiérrez-Peña (2014) and Cremers & Klugkist (2017, working
  paper).
}
\examples{
library(bpnreg)
bpnme(Error.rad ~ Maze + Trial.type + (1|Subject), Maps, its = 100)

}
