% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{boxoffice}
\alias{boxoffice}
\title{Download Information on Box Office Results for Movies}
\usage{
boxoffice(dates, site = c("mojo", "numbers"), top_n = NULL)
}
\arguments{
\item{dates}{A vector of dates to scrape}

\item{site}{Whether you want to get data from boxofficemojo.com or the-numbers.com.
Accepts inputs of "mojo" (default) or "numbers".}

\item{top_n}{The number of results to return for each day. If NULL (default) returns
all results, otherwise just top n  results (e.g. top_n = 5, returns 5 top
movies per date).}
}
\value{
Data frame returning info on the name of the movie, its daily gross,
 gross-to-date, and gross-per-theater for each date inputted.
}
\description{
Download Information on Box Office Results for Movies
}
\examples{
boxoffice(dates = as.Date("2017-12-25"))

# Uses the-numbers.com website.
boxoffice(dates = as.Date("2017-12-25"), site = "numbers")

# Returns only top 10 (daily) grossing movies#'
boxoffice(dates = as.Date("2017-12-25"), top_n = 10)
# Uses the dates of Christmas and New Years Eve 2017
boxoffice(dates = as.Date(c("2017-12-25", "2017-12-31")))

}
