\name{sunspot}
\alias{sunspot}
\title{
Annual Mean Sunspot Numbers
}
\section{SUMMARY}{
\code{sunspot} is a time series of class \code{"rts"} and contains 289 observations.


The Zurich sunspot numbers have been analyzed in almost all books on time
series analysis as well as numerous papers.  The data set, usually attributed
to Rudolf Wolf, consists of means of daily relative numbers of sunspot 
sightings.
The relative number for a day is given by k(f+10g) where g is the number of
sunspot groups observed, f is the total number of spots within the groups and
k is a scaling factor relating the observer and telescope to a baseline. The
relative numbers are then averaged to give an annual figure.   
See Insenman (1983) for a discussion of the relative numbers. The figures are
for the years 1700-1988.
}
\section{NOTE}{
These data are not related to dataset of the same name in the \code{trellis} 
library.  They are, however, similar to the \code{S-Plus} dataset \code{sunspots}
except that this set contains annual averages instead of monthly averages
and it is for a longer period of time.
}
\section{SOURCE}{
The data were obtained from


Tong, H. (1990) \emph{Nonlinear Time Series: A Dynamical System Approach}.
Oxford University Press
}
\section{OTHER REFERENCES}{
Davison, A.C. and Hinkley, D.V. (1997) 
\emph{Bootstrap Methods and Their Application}. Cambridge University Press.


Inzenman, A.J. (1983) J.R. Wolf and H.A. Wolfer: An historical note on the
Zurich sunspot relative numbers. 
\emph{Journal of the Royal Statistical Society, A}, \bold{146},
311-318.


Waldmeir, M. (1961) \emph{The Sunspot Activity in the Years 1610-1960}.
Schulthess and Co.
}
\keyword{datasets}
% Converted by Sd2Rd version 0.3-1.
