% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomials.R
\name{legendre_polynomials}
\alias{legendre_polynomials}
\alias{legendre_p}
\alias{legendre_p_prime}
\alias{legendre_p_zeros}
\alias{legendre_p_m}
\alias{legendre_q}
\alias{legendre_next}
\alias{legendre_next_m}
\title{Legendre Polynomials and Related Functions}
\usage{
legendre_p(n, x)

legendre_p_prime(n, x)

legendre_p_zeros(n)

legendre_p_m(n, m, x)

legendre_q(n, x)

legendre_next(n, x, Pl, Plm1)

legendre_next_m(n, m, x, Pl, Plm1)
}
\arguments{
\item{n}{Degree of the polynomial}

\item{x}{Argument of the polynomial}

\item{m}{Order of the polynomial (for Legendre polynomials of the first kind)}

\item{Pl}{Value of the Legendre polynomial \eqn{(P_l(x))}}

\item{Plm1}{Value of the Legendre polynomial \eqn{(P_{l-1}(x))}}
}
\value{
A single numeric value with the computed Legendre polynomial, its derivative, zeros, or related functions.
}
\description{
Functions to compute Legendre polynomials of the first and second kind, their derivatives, zeros, and related functions.
}
\examples{
# Legendre polynomial of the first kind P_2(0.5)
legendre_p(2, 0.5)
# Derivative of the Legendre polynomial of the first kind P_2'(0.5)
legendre_p_prime(2, 0.5)
# Zeros of the Legendre polynomial of the first kind P_2
legendre_p_zeros(2)
# Legendre polynomial of the first kind with order 1 P_2^1(0.5)
legendre_p_m(2, 1, 0.5)
# Legendre polynomial of the second kind Q_2(0.5)
legendre_q(2, 0.5)
# Next Legendre polynomial of the first kind P_3(0.5) using P_2(0.5) and P_1(0.5)
legendre_next(2, 0.5, legendre_p(2, 0.5), legendre_p(1, 0.5))
# Next Legendre polynomial of the first kind with order 1 P_3^1(0.5) using P_2^1(0.5) and P_1^1(0.5)
legendre_next_m(2, 1, 0.5, legendre_p_m(2, 1, 0.5), legendre_p_m(1, 1, 0.5))
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/sf_poly/legendre.html}{Boost Documentation} for more details on the mathematical background.
}
