% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negative_binomial_distribution.R
\name{negative_binomial_distribution}
\alias{negative_binomial_distribution}
\alias{negative_binomial_pdf}
\alias{negative_binomial_lpdf}
\alias{negative_binomial_cdf}
\alias{negative_binomial_lcdf}
\alias{negative_binomial_quantile}
\title{Negative Binomial Distribution Functions}
\usage{
negative_binomial_pdf(x, successes, success_fraction)

negative_binomial_lpdf(x, successes, success_fraction)

negative_binomial_cdf(x, successes, success_fraction)

negative_binomial_lcdf(x, successes, success_fraction)

negative_binomial_quantile(p, successes, success_fraction)
}
\arguments{
\item{x}{quantile}

\item{successes}{number of successes (successes >= 0)}

\item{success_fraction}{probability of success on each trial (0 <= success_fraction <= 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Negative Binomial distribution.
}
\examples{
negative_binomial_pdf(3, 5, 0.5)
negative_binomial_lpdf(3, 5, 0.5)
negative_binomial_cdf(3, 5, 0.5)
negative_binomial_lcdf(3, 5, 0.5)
negative_binomial_quantile(0.5, 5, 0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/negative_binomial_dist.html}{Boost Documentation} for more details on the mathematical background.
}
