% File man/getSnpWeights.Rd
\name{getSnpWeights}
\alias{getSnpWeights}
\title{Extract p-value weights from a GWAS resultfile}

\description{
This is a very simple function that extracts for a number of SNPs their p-value from an association result file, e.g. generated by PLINK.
}

\usage{
getSnpWeights(
  snps, 
  gwas.resultfile, 
  pColname = "P", 
  snpColname = "SNP"
) 
}

\arguments{
  \item{snps}{character. A vector of SNP identifiers for that p-values are extracted from \code{gwas.resultfile}.}
  \item{gwas.resultfile}{character. Path/filename to the file containing SNPs and p-values. Has to contain a column header line and be readable by the \code{\link{read.table}} function.}
  \item{pColname}{character. Name of the column containing p-values.}
  \item{snpColname}{character. Name of the column containing SNP identifiers.}
}

\value{
  A vector containing wheights which are 1 plus the difference to the smallest log P among all SNPs requested. 
  Names of the elements are the according SNP IDs.
}

\examples{
## path to example data
gwas.resultfile <- system.file("extdata", "example.gwas", package = "boostSeq")

getSnpWeights(snps = c("rs8411", "rs7960808"), gwas.resultfile)  
}
