% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bold_tax_id}
\alias{bold_tax_id}
\title{Search BOLD for taxonomy data by BOlD ID.}
\usage{
bold_tax_id(id = NULL, dataTypes = "basic", includeTree = FALSE,
  response = FALSE, ...)
}
\arguments{
\item{id}{(integer) One or more BOLD taxonomic identifiers}

\item{dataTypes}{(character) Specifies the datatypes that will be returned. 'all' returns all data.
'basic' returns basic taxon information. 'images' returns specimen images.}

\item{includeTree}{(logical) If TRUE (default: FALSE), returns a list containing information
for parent taxa as well as the specified taxon.}

\item{response}{(logical) Note that response is the object that returns from the Curl call,
useful for debugging, and getting detailed info on the API call.}

\item{...}{Further args passed on to httr::GET, main purpose being curl debugging}
}
\description{
Search BOLD for taxonomy data by BOlD ID.
}
\examples{
\dontrun{
bold_tax_id(id=88899)
bold_tax_id(id=88899, includeTree=TRUE)
bold_tax_id(id=c(88899,125295))

## get httr response object only
bold_tax_id(id=88899, response=TRUE)
bold_tax_id(id=c(88899,125295), response=TRUE)

## curl debugging
library('httr')
bold_tax_id(id=88899, config=verbose())
}
}
\references{
\url{http://boldsystems.org/index.php/resources/api?type=taxonomy#idParameters}
}

