% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_selected_variables}
\alias{plot_selected_variables}
\title{Plot selected variables from a \code{bolasso} object.}
\usage{
plot_selected_variables(
  x,
  covariates = NULL,
  threshold = 0.95,
  method = c("vip", "qnt"),
  ...
)
}
\arguments{
\item{x}{An object of class \link{bolasso} or \code{bolasso_fast}.}

\item{covariates}{A subset of the selected covariates to plot. This should be a
vector of covariate names either as strings or bare. E.g.
\code{covariates = c("var_1", "var_2")} or \code{covariates = c(var_1, var_2)}.
This argument is optional and is \code{NULL} by default. In this case it will
plot up to 30 covariates with the largest absolute mean coefficients.}

\item{threshold}{A numeric between 0 and 1, specifying the variable
selection threshold to use.}

\item{method}{The variable selection method to use. The two valid options
are \code{c("vip", "qnt")}. The default \code{"vip"} and is the method described in
the original Bach (2008) and complementary Bunea et al. (2011) works. The
\code{"qnt"} method is the method proposed by Abram et al. (2016).}

\item{...}{Additional arguments to pass to \code{\link{coef}} on
objects with class \code{bolasso} or \code{bolass_fast}.}
}
\description{
The method plots coefficient distributions for the selected covariates
in the \code{bolasso} model. If there are more than 30 selected covariates,
this will plot the 30 selected covariates with the largest
absolute mean coefficient. The user can also plot coefficient distributions
for a specified subset of selected covariates.
}
