% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_p_ind_admix.R
\name{make_p_ind_admix}
\alias{make_p_ind_admix}
\title{Construct individual-specific allele frequency matrix under the PSD admixture model}
\usage{
make_p_ind_admix(p_subpops, admix_proportions)
}
\arguments{
\item{p_subpops}{The \eqn{m \times k}{m-by-k} matrix of intermediate subpopulation allele frequencies.}

\item{admix_proportions}{The \eqn{n \times k}{n-by-k} matrix of admixture proportions.}
}
\value{
The \eqn{m \times n}{m-by-n} matrix of individual-specific allele frequencies.
}
\description{
Here \eqn{m} is the number of loci, \eqn{n} the number of individuals, and \eqn{k} the number of intermediate subpopulations.
The \eqn{m \times n}{m-by-n} individual-specific allele frequency matrix \eqn{P} is constructed from the \eqn{m \times k}{m-by-k} intermediate subpopulation allele frequency matrix \eqn{B} and the \eqn{n \times k}{n-by-k} admixture proportion matrix \eqn{Q} using
\deqn{P = B Q^T.}{P = B * Q^T.}
This function is a wrapper around \code{\link{tcrossprod}}, but also ensures the output allele frequencies are in [0, 1], as this is not guaranteed by \code{\link{tcrossprod}} due to limited machine precision.
}
\examples{
# data dimensions
# number of loci
m_loci <- 10
# number of individuals
n_ind <- 5
# number of intermediate subpops
k_subpops <- 2

# FST values for k = 2 subpops
inbr_subpops <- c(0.1, 0.3)

# non-trivial admixture proportions
admix_proportions <- admix_prop_1d_linear(n_ind, k_subpops, sigma = 1)

# random vector of ancestral allele frequencies
p_anc <- draw_p_anc(m_loci)

# matrix of intermediate subpop allele freqs
p_subpops <- draw_p_subpops(p_anc, inbr_subpops)

# matrix of individual-specific allele frequencies
p_ind <- make_p_ind_admix(p_subpops, admix_proportions)

}
