% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodesplit.network.R
\name{nodesplit.network.data}
\alias{nodesplit.network.data}
\title{Make a network object containing data, priors, and a JAGS model file}
\usage{
nodesplit.network.data(
  Outcomes = NULL,
  Study = NULL,
  Treat = NULL,
  N = NULL,
  SE = NULL,
  response = NULL,
  Treat.order = NULL,
  pair = NULL,
  type = "random",
  dic = FALSE
)
}
\arguments{
\item{Outcomes}{Arm-level outcomes. If it is a multinomial response, the matrix would have dimensions treatment arms (row) by multinomial categories (column). If it is binomial or normal, it would be a vector.}

\item{Study}{A vector of study indicator for each arm}

\item{Treat}{A vector of treatment indicator for each arm}

\item{N}{A vector of total number of observations in each arm. Used for binomial and multinomial responses}

\item{SE}{A vector of standard error for each arm. Used only for normal response}

\item{response}{Specification of the outcomes type. Must specify one of the following: "normal", "binomial", or "multinomial"}

\item{Treat.order}{Treatment order which determines how treatments are compared. The first treatment that is specified is considered to be the baseline treatment. Default order is alphabetical. If the treatments are coded 1, 2, etc, then the treatment with a value of 1 would be assigned as a baseline treatment.}

\item{pair}{Define a pair to split. It has to be a vector of length 2 with treatment names}

\item{type}{Type of model fitted: either "random" for random effects model or "fixed" for fixed effects model. Default is "random".}

\item{dic}{This is an indicator for whether user wants to calculate DIC. Model stores less information if you set it to FALSE. Default is set to FALSE.}
}
\value{
Creates list of variables that are used to run the model using \code{\link{nodesplit.network.run}}
\item{data}{Data combining all the input data. User can check this to insure the data is correctly specified. For modelling purposes, character valued studies or treatment variables are changed to numeric values based on alphabetical order.}
\item{nrow}{Total number of arms in the meta-analysis}
\item{ncat}{Number of columns in the Outcomes. Will equal 1 for binary and normal and number of categories for multinomial}
\item{nstudy}{Number of study}
\item{na}{Number of arms for each study}
\item{ntreat}{Number of treatment}
\item{b.id}{Indicator in sequence of all treatments for which treatment is base treatment in Study}
\item{t}{\code{Treat} transformed into a matrix which has dimensions number of study by max number of arms in studies}
\item{r}{\code{Outcomes} made into an array that is suitable for use in rjags code. For multinomial, it has 3 dimensions: number of study by max number of arms in studies by number of categories.}
\item{code}{Rjags model file code that is generated using information provided by the user. To view model file inside R in a nice format, use \code{cat(network$code).}}
}
\description{
This function makes a network object that can be used to run network meta-analysis using \code{\link{nodesplit.network.run}}.
User needs to specify Outcomes, Study, Treat, N or SE, and response.
Prior parameters are filled in automatically based on the data type if not specified.
The input data should be arm-level so that we have observations for each treatment in each study.
The input data is preprocessed to fit the format necessary to run model in JAGS.
}
\examples{
###Thrombolytic data example
network <- with(thrombolytic,{
 nodesplit.network.data(Outcomes, Study, Treat, N, response = "binomial", pair = c(3,9))
})
network
}
\references{
S. Dias, N.J. Welton, D.M. Caldwellb, A.E. Ades (2010), \emph{Checking consistency in mixed treatment}, Statistics in Medicine 29(7-8, Sp. Iss. SI): 932-944. [\url{https://doi.org/10.1002/sim.3767}]
}
