% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMSC-main.R
\name{BMSC}
\alias{BMSC}
\title{Fit Bayesian Multilevel Single Case models}
\usage{
BMSC(
  formula,
  data_ctrl,
  data_sc,
  cores = 1,
  chains = 4,
  warmup = 2000,
  iter = 4000,
  seed = NA,
  typeprior = "normal",
  ...
)
}
\arguments{
\item{formula}{An object of class \code{formula}: a symbolic description of the model to be fitted.}

\item{data_ctrl}{An object of class \code{data.frame} (or one that can be coerced to that class)
containing data of all variables used in the model for the control group.}

\item{data_sc}{An object of class \code{data.frame} (or one that can be coerced to that class)
containing data of all variables used in the model for the Single Case}

\item{cores}{The number of cores to use when executing the Markov chains in parallel. The default is 1.}

\item{chains}{Number of Markov chains (defaults to 4).}

\item{warmup}{A positive integer specifying number of warmup (aka burnin) iterations.
This also specifies the number of iterations used for stepsize adaptation,
so warmup samples should not be used for inference. The number of warmup should
not be larger than iter and the default is 2000.}

\item{iter}{Number of total iterations per chain (including warmup; defaults to 4000).}

\item{seed}{The seed for random number generation to make results reproducible.
If NA (the default), Stan will set the seed randomly.}

\item{typeprior}{Set the desired prior distribution for the fixed effects.
\describe{
\item{normal}{a normal distribution with \eqn{\mu = 0} and \eqn{\sigma = 10}}
\item{cauchy}{a cauchy distribution with \eqn{\mu = 0} and scale \eqn{\sqrt{2}/2}}
\item{student}{a Student's T distribution, with \eqn{\mu = 0}, \eqn{\nu = 3} and \eqn{\sigma = 10}}
}
The normal distribution is the default.}

\item{...}{further arguments to be passed to \strong{stan} function.}
}
\value{
a \code{BMSC} object
}
\description{
\code{BMSC} fits the Bayesian Multilevel Single Case models.
}
\examples{
 \donttest{

 data(BSE)

# Linear regression of data coming from a body representation paradigm
# with a control sample of 12 participants and one patient with
# unilateral brachial plexus lesion
mdl <- BMSC(formula = RT ~ Body.District * Congruency * Side +
            (Body.District + Congruency + Side | ID),
            data_ctrl = data.ctrl,
            data_sc = data.pt,
            cores = 4)

 # generate a summary of the results
 summary(mdl)

 # posterior predictive p-value checking
 pp_check(mdl, limited = FALSE)

 # plot of the results
 plot(mdl)

# simulation of healthy controls data

Sigma.ctrl <- matrix(cbind(1, .7,  .7, 1) ,nrow=2)

U <- t(chol(Sigma.ctrl))

numobs <- 100

set.seed(123)

random.normal <- matrix( rnorm( n = ncol(U) * numobs, mean = 3, sd = 1),
                         nrow = ncol(U), ncol = numobs)

X = U \%*\% random.normal

dat.ctrl <- as.data.frame(t(X))

names(dat.ctrl) <- c("y","x")

cor(dat.ctrl)

# simulation of patient data

Sigma.pt <- matrix(cbind(1, 0,  0, 1) ,nrow=2)

U <- t(chol(Sigma.pt))

numobs <- 20

set.seed(0)

random.normal <- matrix( rnorm( n = ncol(U) * numobs, mean = 3, sd = 1),
                 nrow = ncol(U), ncol = numobs)

X = U \%*\% random.normal

dat.pt <- as.data.frame(t(X))

names(dat.pt) <- c("y","x")

cor(dat.pt)

# fit the single case model

mdl.reg <- BMSC(y ~ x, data_ctrl = dat.ctrl, data_sc = dat.pt, seed = 10)

# summarize the data

summary(mdl.reg)
}

}
