% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series.R
\name{get_n_series}
\alias{get_n_series}
\title{Create and execute a query to retrieve one or more time series and their
catalog data}
\usage{
get_n_series(series_ids, api_key, ...)
}
\arguments{
\item{series_ids}{a list or character vector of BLS time-series IDs. If the
list items are named then the names will be used in the returned list}

\item{api_key}{a required API key, available from
\url{https://data.bls.gov/registrationEngine/}}

\item{...}{additional parameters to pass to \link{query_n_series}}
}
\value{
a list of series results (a list of lists)
}
\description{
Create and execute a query to retrieve one or more time series and their
catalog data
}
\examples{
\dontrun{
series_ids <- list(uer.men ='LNS14000001', uer.women = 'LNS14000002')
uer_series <- get_n_series(series_ids, 'your-api-key-here' )
}
}
\seealso{
\code{\link{query_n_series}}

Other blsR-requests: 
\code{\link{bls_request}()},
\code{\link{get_all_surveys}()},
\code{\link{get_latest_observation}()},
\code{\link{get_n_series_table}()},
\code{\link{get_popular_series}()},
\code{\link{get_series_tables}()},
\code{\link{get_series_table}()},
\code{\link{get_series}()},
\code{\link{get_survey_info}()}
}
\concept{blsR-requests}
