% Generated by roxygen2 (4.0.0): do not edit by hand
\name{SGD}
\alias{SGD}
\alias{print.SGD}
\title{Stochastic Gradient Descent}
\usage{
SGD(X0, lambda0, alpha, h, Dh, data, convTol = 1e-10, relTol = convTol,
  iterLimit = 100, beta = 0.5, batchSize = 1, trace = 0,
  plotTrace = trace, rngSeed = 1234, objFun = NULL, ...)

\method{print}{SGD}(x, ...)
}
\arguments{
\item{X0}{initial value for X}

\item{lambda0}{initial value for lambda}

\item{alpha}{learning rate -- either a constant of a vector whose size is
equal to \code{c(X0, lambda0)}.}

\item{h}{function whose signature is \code{(X,lambda, data)} which is
vectorized over \code{data}. \code{h} is assumed to be non-negative, and SGD
will attempt to minimize it.}

\item{Dh}{gradient of \code{h} as a function of \code{X}, \code{lambda}, and
\code{data}. Also assumed to be vectorized over \code{data}.}

\item{convTol}{positive value which signals \code{h}'s convergence.}

\item{relTol}{positive value. If all parameter estimates and \code{h} do not
change more than \code{relTol} in the course of one iteration, SGD will stop.}

\item{iterLimit}{the maximum number of iterations.}

\item{trace}{non-negative integer. At every \code{trace} iteration,
\code{SGD} will output the current parameter estimates to stdout. A value
of zero indicates no desired output.}

\item{plotTrace}{non-negative integer. At every \code{plotTrace} iteration,
\code{SGD} will graphically output the parameter estimates up to that
iteration. A value of zero indicates no desired output}

\item{rngSeed}{the random number generation seed value.}

\item{objFun}{the objective function in the Lagrangian to be optimized.}

\item{...}{layout arguments to be passed to \code{\link{multiplot}}.}

\item{data}{the data set whose rows (the number of which is determined by
\code{batchSize}) are to be fed to \code{h} and \code{Dh}.}

\item{beta}{annealing constant for step size. See details.}

\item{batchSize}{number of observations to feed to \code{h} and \code{Dh} at
each iteration. When \code{batchSize} is equal to \code{nrow(data)} SGD
will perform exactly like \code{\link{gradientDescent}}.}

\item{x}{an object of class \code{SGD}.}
}
\value{
an '\code{SGD}' object with methods \code{\link{print.SGD}} and
\code{\link{plot.SGD}}. An \code{SGD} object is just a glorified list with
the following entries
\item{X_final}{the last iteration's \code{X} values}
\item{lambda_final}{the last iteration's \code{lambda} values}
\item{X_initial}{the initial \code{X} value}
\item{lambda_initial}{the initia \code{lambda} value}
\item{X}{the matrix whose i-th column contains the i-th iteration's \code{X}
 values }
\item{lambda}{the matrix whose i-th column contains the i-th iteration's
  \code{lambda}  values }
\item{delta}{the vector whose i-th entry contains the value of \code{h} at
the i-th iteration}
\item{alpha}{the given learning rate}
\item{beta}{the given annealing rate}
\item{batchSize}{the given batchSize}
\item{iter}{the number of iterations taken}
\item{convTol}{the given convergence tolerance}
\item{objFun}{the original objective function}
\item{converged}{a boolean indicating if \code{h} was driven below
\code{convTol}}
\item{aboveTol}{a boolean indicating if any \code{X} or \code{lambda} values
stabilized below \code{relTol}}
}
\description{
Minimize a function \code{h} via stochastic gradient descent.
}
\details{


Follows the gradient method described in
\code{inst/final_project/final_paper/final_paper.pdf}.
}
\seealso{
Other gradient methods: \code{\link{gradientDescent}}
}

