% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serve.R
\name{serve_site}
\alias{serve_site}
\alias{stop_server}
\title{Live preview a site}
\usage{
serve_site(...)

stop_server()
}
\arguments{
\item{...}{Arguments passed to \code{servr::httw()} (arguments \code{dir},
\code{site.dir}, \code{baseurl}, and \code{handler} have been provided,
hence you cannot customize these arguments).}
}
\description{
The function \code{serve_site()} calls \code{servr::\link{httw}()} to start a
web server, watch for changes in the site, rebuild the site if necessary, and
refresh the web page automatically by default; \code{stop_server()} stops the
web server.
}
\details{
Alternatively, you can set the global option
\code{\link{options}(blogdown.generator.server = TRUE)}, and
\code{serve_site()} will use the web server provided by the static site
generator, such as \code{\link{hugo_server}()}. This requires additional
packages \pkg{processx} and \pkg{later}. You may use this option when you
primarily work on plain Markdown posts instead of R Markdown posts, because
it can be faster to preview Markdown posts using the web server of the static
site generator. The web server will always be stopped when the R session is
ended, so you may consider restarting your R session if \code{stop_server}
fails to stop the server for some reason.
}
