% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.nppi.R
\name{plot.nppi}
\alias{plot.nppi}
\title{Plot Stability of JAB Point Estimates}
\usage{
\method{plot}{nppi}(x, ...)
}
\arguments{
\item{x}{An object of class \code{nppi}, containing JAB point values.}

\item{...}{
  Arguments passed on to \code{\link[base:plot]{base::plot}}
  \describe{
    \item{\code{y}}{the y coordinates of points in the plot, \emph{optional}
    if \code{x} is an appropriate structure.}
  }}
}
\value{
No return value, called for side effects
}
\description{
S3 Method for objects of class 'nppi'
This function visualizes the JAB point estimates across deletion blocks
 indices used to estimate variance of the NPPI algorithm.
}
\examples{
# Generate AR(1) time series
set.seed(32)
sim <- stats::arima.sim(list(order = c(1, 0, 0), ar = 0.5),
                        n = 500, innov = rnorm(500))

# Estimate the optimal block length for the sample mean
result <- nppi(data = sim, stat_function = mean, num_bootstrap = 500, m = 2)

# Use s3 method
plot(result)

}
