cat("\n\nRUnit test cases for blme::bglmer function\n\n");

# generated by:


test.blme.bglmer <- function()
{
  source(system.file("common", "glmmData.R", package = "blme"));
  
   glmerFit <-  glmer(y ~ x.1 + x.2 + (1 | g), testData, family=binomial());
  bglmerFit <- bglmer(y ~ x.1 + x.2 + (1 | g), testData, family=binomial(),
                      cov.prior = NULL);
  
  checkEquals(glmerFit@theta, bglmerFit@theta);
  checkEquals(glmerFit@beta, bglmerFit@beta);
  checkEquals(glmerFit@u, bglmerFit@u);

  fit <- bglmer(y ~ x.1 + x.2 + (1 | g), testData, family = binomial(),
                cov.prior = wishart);
  checkEquals(fit@theta, 2.96766646709572);
  checkEquals(fit@beta, c(1.09637901132068, 3.67790597689351, 1.75655015184474));

  fit <- bglmer(y ~ x.1 + x.2 + (1 | g), testData, family = binomial(),
                cov.prior = NULL, fixef.prior = normal);
  checkEquals(fit@theta, 1.26502084999465);
  checkEquals(fit@beta, c(0.873134542930456, 2.46647593503492, 1.32070300707973));

  RUnitOptions <- getOption("RUnit");
  RUnitOptions$silent <- TRUE;
  options("RUnit" = RUnitOptions);
  
  checkException(blme:::parsePrior(bglmerFit, fixef.prior = normal(common.scale = TRUE)));
}
