% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-.R
\name{cmd_run}
\alias{cmd_run}
\alias{cmd_background}
\alias{cmd_help}
\title{Execute command}
\usage{
cmd_run(
  command,
  stdout = TRUE,
  stderr = TRUE,
  stdin = NULL,
  timeout = NULL,
  verbose = TRUE
)

cmd_background(
  command,
  stdout = NULL,
  stderr = NULL,
  stdin = NULL,
  verbose = TRUE
)

cmd_help(command, stdout = NULL, stderr = NULL, verbose = TRUE)
}
\arguments{
\item{command}{A \code{command} object.}

\item{stdout, stderr}{How output streams of the child process are processed.
Possible values are:
\itemize{
\item \code{TRUE}: print the child output in R console.
\item \code{FALSE}: suppress output stream
\item \strong{string}: name or path of file to redirect output
\item \code{connection}: a writable R \code{\link{connection}} object
\item \code{function}: a callback function (including purrr-like lambda syntax) with
one argument accepting a raw vector (use \code{\link[sys:as_text]{as_text()}} to
convert to text).
}

For \code{cmd_background()}, only a string (file path), or a single boolean value
can be used.

For \code{cmd_help()}, only a string (file path), \code{connection}, or \code{function} can
be used.}

\item{stdin}{should the input be diverted? A character string naming a file.}

\item{timeout}{Timeout in seconds. This is a limit for the elapsed time
running command in the separate process.}

\item{verbose}{A single boolean value indicating whether the command
execution should be verbose.}
}
\value{
\itemize{
\item \code{cmd_run}: Exit status invisiblely.
}

\itemize{
\item \code{cmd_background}: Returns the process ID, which can be terminated manually
using \code{\link[tools:pskill]{tools::pskill()}}. You can also use \code{\link[sys:exec]{sys::exec_status()}} to check
the process's exit status.
}

\itemize{
\item \code{cmd_help}: the input \code{command} invisiblely.
}
}
\description{
\itemize{
\item \code{cmd_run}: Run the command.
\item \code{cmd_background}: Run the command in the background.
\item \code{cmd_help}: Print the help document for this command.
}
}
\seealso{
\code{\link[=cmd_wd]{cmd_wd()}}/\code{\link[=cmd_envvar]{cmd_envvar()}}/\code{\link[=cmd_envpath]{cmd_envpath()}}
}
