% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bliss_method.R
\name{fit_Bliss}
\alias{fit_Bliss}
\title{fit_Bliss}
\usage{
fit_Bliss(data, param, compute_density = TRUE, sann = TRUE,
  verbose = FALSE)
}
\arguments{
\item{data}{a list containing:
\describe{
\item{Q}{an integer, the number of functional covariates.}
\item{y}{a numerical vector, the outcomes.}
\item{x}{a list of matrices, the qth matrix contains the observations of the
      qth functional covariate at time points given by \code{grids}.}
\item{grids}{a list of numerical vectors, the qth vector is the grid of
       time points for the qth functional covariate.}
}}

\item{param}{a list containing:
\describe{
\item{iter}{an integer, the number of iterations of the Gibbs sampler algorithm.}
\item{K}{a vector of integers, corresponding to the numbers of intervals for
      each covariate.}
\item{basis}{a character vector (optional). The possible values are "uniform" (default),
      "epanechnikov", "gauss" and "triangular" which correspond to
      different basis functions to expand the coefficient function and the
      functional covariates}
\item{burnin}{an integer (optional), the number of iteration to drop from the
      posterior sample.}
\item{iter_sann}{an integer (optional), the number of iteration of the Simulated
      Annealing algorithm.}
\item{k_max}{an integer (optional), the maximal number of intervals for the
      Simulated Annealing algorithm.}
\item{l_max}{an integer (optional), the maximal interval length for the
      Simulated Annealing algorithm.}
\item{lims_kde}{an integer (optional), correspond to the \code{lims} option
      of the \code{kde2d} funtion.}
\item{n_chains}{an integer (optional) which corresponds to the number of
      Gibbs sampler runs.}
\item{new_grids}{a list of Q vectors (optional) to compute beta samples on
      different grids.}
\item{Temp_init}{a nonnegative value (optional), the initial temperature for
     the cooling function of the Simulated Annealing algorithm.}
\item{thin}{an integer (optional) to thin the posterior sample.}
\item{times_sann}{an integer (optional), the number of times the algorithm
      will be executed}
}}

\item{compute_density}{a logical value. If TRUE, the posterior density
of the coefficient function is computed. (optional)}

\item{sann}{a logical value. If TRUE, the Bliss estimate is
computed with a Simulated Annealing Algorithm. (optional)}

\item{verbose}{write stuff if TRUE (optional).}
}
\value{
return a list containing:
\describe{
 \item{alpha}{a list of Q numerical vector. Each vector is the function
       alpha(t) associated to a functional covariate. For each t, alpha(t)
       is the posterior probabilities of the event "the support covers t".}
 \item{beta_posterior_density}{a list of Q items. Each item contains a list
       containing information to plot the posterior density of the
       coefficient function with the \code{image} function.
       \describe{
       \item{\code{grid_t}}{a numerical vector: the x-axis.}
       \item{\code{grid_beta_t}}{a numerical vector: the y-axis.}
       \item{\code{density}}{a matrix: the z values.}
       \item{\code{new_beta_sample}}{a matrix: beta sample used to compute
             the posterior densities.}
       }
       }
 \item{beta_sample}{a list of Q matrices. The qth matrix is a posterior
       sample of the qth functional covariates.}
 \item{Bliss_estimate}{a list of numerical vectors corresponding to the
       Bliss estimates of each functional covariates.}
 \item{chains}{a list of \code{posterior_sample}. \code{chains} is \code{NULL} if
       \code{n_chains}=1.}
 \item{chains_info}{a list for each chain providing: a mu estimate, a sigma_sq estimate,
 the Smooth estimate of the coefficient function and the autocorrelation of the
 Markov Chain.}
 \item{data}{a list containing the data.}
 \item{posterior_sample}{a list of information about the posterior sample:
       the trace matrix of the Gibbs sampler, a list of Gibbs sampler parameters
       and the posterior densities.}
 \item{support_estimate}{a list of support estimates of each functional covariate.}
 \item{support_estimate_fct}{another version of the support estimates.}
 \item{trace_sann}{a list of Q matrices which are the trace of the
       Simulated Annealing algorithm.}
}
}
\description{
Fit the Bayesian Functional
Linear Regression model (with Q functional covariates).
}
\examples{
# see the vignette BlissIntro.
}
