% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continue_funs.R
\name{kmbayes_parallel_continue}
\alias{kmbayes_parallel_continue}
\title{Continue sampling from existing bkmr_parallel fit}
\usage{
kmbayes_parallel_continue(fitkm.list, ...)
}
\arguments{
\item{fitkm.list}{output from \code{\link[bkmrhat]{kmbayes_parallel}}}

\item{...}{arguments to \code{\link[bkmrhat]{kmbayes_continue}}}
}
\value{
a \code{bkmrfit.list} object, which is just a list of \code{bkmrfit} objects similar to \code{\link[bkmrhat]{kmbayes_parallel}}
}
\description{
Use this when you've used MCMC sampling with the \code{\link[bkmrhat]{kmbayes_parallel}} function, but you did not take enough samples and do not want to start over.
}
\examples{
set.seed(111)
dat <- bkmr::SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X
\dontrun{

future::plan(strategy = future::multisession, workers=2)
fitty1p = kmbayes_parallel(nchains=2, y=y,Z=Z,X=X)

fitty2p = kmbayes_parallel_continue(fitty1p, iter=3000)
cobj = as.mcmc.list(fitty2p)
plot(cobj)
}
}
\seealso{
\code{\link[bkmrhat]{kmbayes_parallel}}
}
